﻿    Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Implements ISaveFileDialogCompleted

    Private appService As PhoneApplicationService = PhoneApplicationService.Current
    Private photoChooser As New PhotoChooserTask()
    Private _writeableBitmap As WriteableBitmap


    Public Sub New()
        InitializeComponent()

        appbarLoadButton = TryCast(Me.ApplicationBar.Buttons(0), ApplicationBarIconButton)
        appbarSaveButton = TryCast(Me.ApplicationBar.Buttons(1), ApplicationBarIconButton)

        AddHandler photoChooser.Completed, AddressOf OnPhotoChooserCompleted
    End Sub


    Private Sub OnAppbarLoadClick(ByVal sender As Object, ByVal args As EventArgs)
        appbarSaveButton.IsEnabled = False
        photoChooser.Show()
    End Sub


    Private Sub OnPhotoChooserCompleted(ByVal sender As Object, ByVal args As PhotoResult)
        If args.Error Is Nothing AndAlso args.ChosenPhoto IsNot Nothing Then
            Dim _bitmapImage As New BitmapImage()
            _bitmapImage.SetSource(args.ChosenPhoto)
            _writeableBitmap = New WriteableBitmap(_bitmapImage)

            ' Monochromize
            For pixel = 0 To _writeableBitmap.Pixels.Length - 1
                Dim color = CInt(_writeableBitmap.Pixels(pixel))
                Dim A = CInt(color And &HFF000000L >> 24)
                Dim R = CInt(color And &HFF0000 >> 16)
                Dim G = CInt(color And &HFF00 >> 8)
                Dim B = CInt(color And &HFF)
                Dim gray = CInt(0.3 * R + 0.59 * G + 0.11 * B)

                color = (A << 24) Or (gray << 16) Or (gray << 8) Or gray
                _writeableBitmap.Pixels(pixel) = color
            Next pixel
            img.Source = _writeableBitmap
            appbarSaveButton.IsEnabled = True
        End If
    End Sub


    Private Sub OnAppbarSaveClick(ByVal sender As Object, ByVal args As EventArgs)
        Me.NavigationService.Navigate(
            New Uri("/Petzold.Phone.Silverlight;component/SaveFileDialog.xaml",
                    UriKind.Relative))
    End Sub


    Public Sub SaveFileDialogCompleted(ByVal okPressed As Boolean,
                                       ByVal filename As String) Implements Petzold.Phone.Silverlight.ISaveFileDialogCompleted.SaveFileDialogCompleted
        If okPressed Then
            Dim _memoryStream As New MemoryStream()
            _writeableBitmap.SaveJpeg(_memoryStream,
                                     _writeableBitmap.PixelWidth,
                                     _writeableBitmap.PixelHeight,
                                     0,
                                     75)
            _memoryStream.Position = 0

            Dim mediaLib As New MediaLibrary()
            mediaLib.SavePicture(filename, _memoryStream)
        End If
    End Sub


    Protected Overrides Sub OnNavigatedFrom(ByVal args As NavigationEventArgs)
        If _writeableBitmap IsNot Nothing Then
            Dim stream As New MemoryStream()
            _writeableBitmap.SaveJpeg(stream,
                                     _writeableBitmap.PixelWidth,
                                     _writeableBitmap.PixelHeight,
                                     0,
                                     75)
            appService.State("jpegBits") = stream.GetBuffer()
        End If

        If TypeOf args.Content Is SaveFileDialog Then
            Dim page = TryCast(args.Content, SaveFileDialog)
            page.SetTitle(ApplicationTitle.Text)
        End If

        MyBase.OnNavigatedFrom(args)
    End Sub


    Protected Overrides Sub OnNavigatedTo(ByVal args As NavigationEventArgs)
        If appService.State.ContainsKey("jpegBits") Then
            Dim bitmapBits() = CType(appService.State("jpegBits"), Byte())
            Dim stream As New MemoryStream(bitmapBits)
            Dim bitmapImage As New BitmapImage()
            bitmapImage.SetSource(stream)
            _writeableBitmap = New WriteableBitmap(bitmapImage)
            img.Source = _writeableBitmap
            appbarSaveButton.IsEnabled = True
        End If

        MyBase.OnNavigatedTo(args)
    End Sub
End Class